<?php

namespace Database\Seeders;

use App\Models\Page;
use App\Models\User;
use Illuminate\Database\Seeder;

class FavoritedSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::excludeAdmin()->get();
        $users->each(function ($user) {
            $count = rand(2, 10);
            $pages = Page::randomOf($count)->get();
            $user->favoriteds()->attach($pages);
        });
    }
}
