<?php

namespace Database\Factories;

use App\Repos\PlanRepo;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class UserFactory extends Factory
{
    public function definition(): array
    {
        return [
            'stripe_id' => 'cus_' . Str::random(14),
            'plan_id' => PlanRepo::firstRandom(),
            'name' => fake()->name(),
            'email' => fake()->unique()->safeEmail(),
            'photo' => fake()->imageUrl(200, 200, 'people'),
            'auth_token' => Str::uuid(),
            'verify_token' => Str::uuid(),
            'blocked' => false,
            'admin' => false,
            'created_at' => fake()->dateTimeBetween('-1 year', 'now'),
            'updated_at' => fake()->dateTimeBetween('-1 year', 'now'),
        ];
    }

    public function blocked(): Factory
    {
        return $this->state(fn () => ['blocked' => true]);
    }

    public function admin(): Factory
    {
        return $this->state(fn () => [
            'stripe_id' => null,
            'verify_token' => null,
            'admin' => true,
        ]);
    }
}
