<?php

namespace App\Repos;

use App\Models\Plan;

class PlanRepo
{
    public static function firstRandom()
    {
        return Plan::inRandomOrder()->first();
    }

    public static function firstByNameOrFail(string $name)
    {
        return Plan::whereName($name)->firstOrFail();
    }

    public static function list()
    {
        return Plan::all();
    }

    public static function listPaid()
    {
        return Plan::where('paid', true)
            ->get();
    }

    public static function findByIdOrFail(int $id)
    {
        return Plan::findOrFail($id);
    }

    public static function updateByIdOrFail(int $id, array $plan)
    {
        return Plan::findOrFail($id)->update($plan);
    }

    public static function findByStripePriceIdOrFail(string $stripePriceId)
    {
        return Plan::where('stripe_price_id', $stripePriceId)->firstOrFail();
    }

    public static function hasStripePriceIdForPaids()
    {
        return Plan::where('paid', true)
            ->whereNull('stripe_price_id')
            ->doesntExist();
    }
}
