<?php

namespace App\Http\Controllers;

use App\Repos\PlanRepo;
use App\Repos\SettingRepo;
use App\Services\ResponseService;
use Throwable;

class AppController extends Controller
{
    public function status()
    {
        try {
            $status = [
                'openaiApi' => SettingRepo::hasValueByName('openai_key'),
                'stripeApi' => SettingRepo::hasValueByName('stripe_key'),
                'stripeWebhook' => SettingRepo::hasValueByName('stripe_webhook_secret'),
                'plans' => PlanRepo::hasStripePriceIdForPaids(),
            ];
            return ResponseService::ok($status);
        } catch (Throwable $error) {
            return ResponseService::handleError($error);
        }
    }
}
